// OptionsDlg.cpp : implementation file
//

#include "stdafx.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionsDlg dialog


COptionsDlg::COptionsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptionsDlg)
	//}}AFX_DATA_INIT
}


void COptionsDlg::DoDataExchange(CDataExchange* pDX)
{
	
	CDialog::DoDataExchange(pDX);

	if (!pDX->m_bSaveAndValidate)
	{
		m_PS_Home = McodeActions[0].String;
	}

	
	//{{AFX_DATA_MAP(COptionsDlg)
	DDX_Text(pDX, IDC_PS_Home, m_PS_Home);
	DDV_MaxChars(pDX, m_PS_M3, 255);
	//}}AFX_DATA_MAP

	DDX_CBIndex(pDX, IDC_Action_M3, McodeActions[3].Action);
	DDX_CBIndex(pDX, IDC_Action_M4, McodeActions[4].Action);
	DDX_CBIndex(pDX, IDC_Action_M5, McodeActions[5].Action);
	DDX_CBIndex(pDX, IDC_Action_M6, McodeActions[6].Action);
	DDX_CBIndex(pDX, IDC_Action_M7, McodeActions[7].Action);
	DDX_CBIndex(pDX, IDC_Action_M8, McodeActions[8].Action);
	DDX_CBIndex(pDX, IDC_Action_M9, McodeActions[9].Action);
	
	DDX_CBIndex(pDX, IDC_Action_M10, McodeActions[10].Action); // special case for spindle

	DDX_Text(pDX, IDC_P1_M3,  McodeActions[3 ].dParams[0]);
	DDX_Text(pDX, IDC_P1_M4,  McodeActions[4 ].dParams[0]);
	DDX_Text(pDX, IDC_P1_M5,  McodeActions[5 ].dParams[0]);
	DDX_Text(pDX, IDC_P1_M6,  McodeActions[6 ].dParams[0]);
	DDX_Text(pDX, IDC_P1_M7,  McodeActions[7 ].dParams[0]);
	DDX_Text(pDX, IDC_P1_M8,  McodeActions[8 ].dParams[0]);
	DDX_Text(pDX, IDC_P1_M9,  McodeActions[9 ].dParams[0]);
	DDX_Text(pDX, IDC_P1_M10, McodeActions[10].dParams[0]);

	DDX_Text(pDX, IDC_P2_M3,  McodeActions[3 ].dParams[1]);
	DDX_Text(pDX, IDC_P2_M4,  McodeActions[4 ].dParams[1]);
	DDX_Text(pDX, IDC_P2_M5,  McodeActions[5 ].dParams[1]);
	DDX_Text(pDX, IDC_P2_M6,  McodeActions[6 ].dParams[1]);
	DDX_Text(pDX, IDC_P2_M7,  McodeActions[7 ].dParams[1]);
	DDX_Text(pDX, IDC_P2_M8,  McodeActions[8 ].dParams[1]);
	DDX_Text(pDX, IDC_P2_M9,  McodeActions[9 ].dParams[1]);
	DDX_Text(pDX, IDC_P2_M10, McodeActions[10].dParams[1]);

	DDX_Text(pDX, IDC_P3_M3,  McodeActions[3 ].dParams[2]);
	DDX_Text(pDX, IDC_P3_M4,  McodeActions[4 ].dParams[2]);
	DDX_Text(pDX, IDC_P3_M5,  McodeActions[5 ].dParams[2]);
	DDX_Text(pDX, IDC_P3_M6,  McodeActions[6 ].dParams[2]);
	DDX_Text(pDX, IDC_P3_M7,  McodeActions[7 ].dParams[2]);
	DDX_Text(pDX, IDC_P3_M8,  McodeActions[8 ].dParams[2]);
	DDX_Text(pDX, IDC_P3_M9,  McodeActions[9 ].dParams[2]);
	DDX_Text(pDX, IDC_P3_M10, McodeActions[10].dParams[2]);

	DDX_Text(pDX, IDC_P4_M3,  McodeActions[3 ].dParams[3]);
	DDX_Text(pDX, IDC_P4_M4,  McodeActions[4 ].dParams[3]);
	DDX_Text(pDX, IDC_P4_M5,  McodeActions[5 ].dParams[3]);
	DDX_Text(pDX, IDC_P4_M6,  McodeActions[6 ].dParams[3]);
	DDX_Text(pDX, IDC_P4_M7,  McodeActions[7 ].dParams[3]);
	DDX_Text(pDX, IDC_P4_M8,  McodeActions[8 ].dParams[3]);
	DDX_Text(pDX, IDC_P4_M9,  McodeActions[9 ].dParams[3]);
	DDX_Text(pDX, IDC_P4_M10, McodeActions[10].dParams[3]);

	DDX_Text(pDX, IDC_P5_M3,  McodeActions[3 ].dParams[4]);
	DDX_Text(pDX, IDC_P5_M4,  McodeActions[4 ].dParams[4]);
	DDX_Text(pDX, IDC_P5_M5,  McodeActions[5 ].dParams[4]);
	DDX_Text(pDX, IDC_P5_M6,  McodeActions[6 ].dParams[4]);
	DDX_Text(pDX, IDC_P5_M7,  McodeActions[7 ].dParams[4]);
	DDX_Text(pDX, IDC_P5_M8,  McodeActions[8 ].dParams[4]);
	DDX_Text(pDX, IDC_P5_M9,  McodeActions[9 ].dParams[4]);
	DDX_Text(pDX, IDC_P5_M10, McodeActions[10].dParams[4]);

	if (pDX->m_bSaveAndValidate)
	{
		strncpy(McodeActions[3 ].String,m_PS_M3, 255);
		strncpy(McodeActions[4 ].String,m_PS_M4, 255);
		strncpy(McodeActions[5 ].String,m_PS_M5, 255);
		strncpy(McodeActions[6 ].String,m_PS_M6, 255);
		strncpy(McodeActions[7 ].String,m_PS_M7, 255);
		strncpy(McodeActions[8 ].String,m_PS_M8, 255);
		strncpy(McodeActions[9 ].String,m_PS_M9, 255);
		strncpy(McodeActions[10].String,m_PS_M10,255);
	}

}


BEGIN_MESSAGE_MAP(COptionsDlg, CDialog)
	//{{AFX_MSG_MAP(COptionsDlg)
	ON_BN_CLICKED(IDC_BrowseToolFile, OnBrowseToolFile)
	ON_BN_CLICKED(IDC_BrowseSetupFile, OnBrowseSetupFile)
	ON_CBN_CLOSEUP(IDC_Action_M3, OnCloseupAction)
	ON_BN_CLICKED(IDC_Dir_M3, OnDirM3)
	ON_BN_CLICKED(IDC_Dir_M4, OnDirM4)
	ON_BN_CLICKED(IDC_Dir_M5, OnDirM5)
	ON_BN_CLICKED(IDC_Dir_M6, OnDirM6)
	ON_BN_CLICKED(IDC_Dir_M7, OnDirM7)
	ON_BN_CLICKED(IDC_Dir_M8, OnDirM8)
	ON_BN_CLICKED(IDC_Dir_M9, OnDirM9)
	ON_CBN_CLOSEUP(IDC_Action_M4, OnCloseupAction)
	ON_CBN_CLOSEUP(IDC_Action_M5, OnCloseupAction)
	ON_CBN_CLOSEUP(IDC_Action_M6, OnCloseupAction)
	ON_CBN_CLOSEUP(IDC_Action_M7, OnCloseupAction)
	ON_CBN_CLOSEUP(IDC_Action_M8, OnCloseupAction)
	ON_CBN_CLOSEUP(IDC_Action_M9, OnCloseupAction)
	ON_CBN_CLOSEUP(IDC_Action_M10, OnCloseupAction)
	ON_BN_CLICKED(IDC_Dir_M10, OnDirM10)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionsDlg message handlers

void COptionsDlg::OnBrowseOptionsDlg() 
{
	CFileDialog FileDlg (TRUE, ".tbl", NULL, 
		OFN_FILEMUSTEXIST, 
		"Tool Files (*.tbl)|*.tbl|All Files (*.*)|*.*||");
	
	if (FileDlg.DoModal() == IDOK)
	{
		m_ToolFile = FileDlg.GetPathName();
		UpdateData(FALSE);
	}
}

void COptionsDlg::OnBrowseSetupFile() 
{
	CFileDialog FileDlg (TRUE, ".set", NULL, 
		OFN_FILEMUSTEXIST, 
		"Setup Files (*.set)|*.set|All Files (*.*)|*.*||");
	
	if (FileDlg.DoModal() == IDOK)
	{
		m_SetupFile = FileDlg.GetPathName();
		UpdateData(FALSE);
	}
}

void COptionsDlg::OnOK() 
{
	if (!UpdateData()) return;

	for (int i=3; i<MAX_MCODE_ACTIONS; i++)
		if (VerifyAction(i)) return;
	
	CDialog::OnOK();
}

BOOL COptionsDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	SetAllActions();	

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void COptionsDlg::SetAction(int M, int ID_Action, 
						  int ID_S1, int ID_S2, int ID_S3, int ID_S4, int ID_S5, int ID_Dir,
						  int ID_P1, int ID_P2, int ID_P3, int ID_P4, int ID_P5, int ID_PS)
{
	switch (McodeActions[M].Action)
	{
	case M_Action_None:
		GetDlgItem(ID_S1)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_S2)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_S3)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_S4)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_S5)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_P1)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_P2)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_P3)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_P4)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_P5)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_PS)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_Dir)->ShowWindow(SW_HIDE);
		break;

	case M_Action_Setbit:
		SetDlgItemText(ID_S1,"Set bit");
		SetDlgItemText(ID_S2,"to");
		GetDlgItem(ID_S1)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_S2)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_S3)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_S4)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_S5)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_P1)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_P2)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_P3)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_P4)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_P5)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_PS)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_Dir)->ShowWindow(SW_HIDE);
		break;

	case M_Action_SetTwoBits:
		SetDlgItemText(ID_S1,"Set bit");
		SetDlgItemText(ID_S2,"to");
		SetDlgItemText(ID_S3,"&& bit");
		SetDlgItemText(ID_S4,"to");
		GetDlgItem(ID_S1)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_S2)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_S3)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_S4)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_S5)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_P1)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_P2)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_P3)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_P4)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_P5)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_PS)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_Dir)->ShowWindow(SW_HIDE);
		break;

	case M_Action_DAC:
		SetDlgItemText(ID_S1,"Set DAC");
		SetDlgItemText(ID_S2,"scale");
		SetDlgItemText(ID_S3,"offset");
		SetDlgItemText(ID_S4,"min");
		SetDlgItemText(ID_S5,"max");
		GetDlgItem(ID_S1)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_S2)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_S3)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_S4)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_S5)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_P1)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_P2)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_P3)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_P4)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_P5)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_PS)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_Dir)->ShowWindow(SW_HIDE);
		break;



	case M_Action_Program:
		SetDlgItemText(ID_S1,"Thread");
		SetDlgItemText(ID_S2,"VAR");
		SetDlgItemText(ID_S3,"C File");
		GetDlgItem(ID_S1)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_S2)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_S3)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_S4)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_S5)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_P1)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_P2)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_P3)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_P4)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_P5)->ShowWindow(SW_HIDE);
		GetDlgItem(ID_PS)->ShowWindow(SW_SHOW);
		GetDlgItem(ID_Dir)->ShowWindow(SW_SHOW);
		break;
	}
}

void COptionsDlg::SetAllActions()
{
	SetAction(3, IDC_Action_M3, IDC_S1_M3,IDC_S2_M3,IDC_S3_M3,IDC_S4_M3,IDC_S5_M3,IDC_Dir_M3,
								IDC_P1_M3,IDC_P2_M3,IDC_P3_M3,IDC_P4_M3,IDC_P5_M3,IDC_PS_M3);
	SetAction(4, IDC_Action_M4, IDC_S1_M4,IDC_S2_M4,IDC_S3_M4,IDC_S4_M4,IDC_S5_M4,IDC_Dir_M4,
								IDC_P1_M4,IDC_P2_M4,IDC_P3_M4,IDC_P4_M4,IDC_P5_M4,IDC_PS_M4);
	SetAction(5, IDC_Action_M5, IDC_S1_M5,IDC_S2_M5,IDC_S3_M5,IDC_S4_M5,IDC_S5_M5,IDC_Dir_M5,
								IDC_P1_M5,IDC_P2_M5,IDC_P3_M5,IDC_P4_M5,IDC_P5_M5,IDC_PS_M5);
	SetAction(6, IDC_Action_M6, IDC_S1_M6,IDC_S2_M6,IDC_S3_M6,IDC_S4_M6,IDC_S5_M6,IDC_Dir_M6,
								IDC_P1_M6,IDC_P2_M6,IDC_P3_M6,IDC_P4_M6,IDC_P5_M6,IDC_PS_M6);
	SetAction(7, IDC_Action_M7, IDC_S1_M7,IDC_S2_M7,IDC_S3_M7,IDC_S4_M7,IDC_S5_M7,IDC_Dir_M7,
								IDC_P1_M7,IDC_P2_M7,IDC_P3_M7,IDC_P4_M7,IDC_P5_M7,IDC_PS_M7);
	SetAction(8, IDC_Action_M8, IDC_S1_M8,IDC_S2_M8,IDC_S3_M8,IDC_S4_M8,IDC_S5_M8,IDC_Dir_M8,
								IDC_P1_M8,IDC_P2_M8,IDC_P3_M8,IDC_P4_M8,IDC_P5_M8,IDC_PS_M8);
	SetAction(9, IDC_Action_M9, IDC_S1_M9,IDC_S2_M9,IDC_S3_M9,IDC_S4_M9,IDC_S5_M9,IDC_Dir_M9,
								IDC_P1_M9,IDC_P2_M9,IDC_P3_M9,IDC_P4_M9,IDC_P5_M9,IDC_PS_M9);
	
	//Spindle S Action
	SetAction(10, IDC_Action_M10, IDC_S1_M10,IDC_S2_M10,IDC_S3_M10,IDC_S4_M10,IDC_S5_M10,IDC_Dir_M10,
								 IDC_P1_M10,IDC_P2_M10,IDC_P3_M10,IDC_P4_M10,IDC_P5_M10,IDC_PS_M10);
}

void COptionsDlg::OnCloseupAction() 
{
	if (!UpdateData()) return;
	SetAllActions();
}




void COptionsDlg::OnDirM3() 
{
	DoDirectoryBrowse(3);
}

void COptionsDlg::OnDirM4() 
{
	DoDirectoryBrowse(4);
}

void COptionsDlg::OnDirM5() 
{
	DoDirectoryBrowse(5);
}

void COptionsDlg::OnDirM6() 
{
	DoDirectoryBrowse(6);
}

void COptionsDlg::OnDirM7() 
{
	DoDirectoryBrowse(7);
}

void COptionsDlg::OnDirM8() 
{
	DoDirectoryBrowse(8);
}

void COptionsDlg::OnDirM9() 
{
	DoDirectoryBrowse(9);
}

void COptionsDlg::OnDirM10() 
{
	DoDirectoryBrowse(10);
}

void COptionsDlg::DoDirectoryBrowse(int m)
{
	CFileDialog FileDlg (TRUE, ".tbl", NULL, 
		OFN_FILEMUSTEXIST, 
		"C Files (*.c)|*.c|All Files (*.*)|*.*||");
	
	if (FileDlg.DoModal() == IDOK)
	{
		strncpy(McodeActions[m].String,FileDlg.GetPathName(), 255);
		UpdateData(FALSE);
	}
}

// verify that an action makes sense

int COptionsDlg::VerifyAction(int i)
{
	CString MCode;

	if (i!=10)
		MCode.Format("M%d - ",i);
	else
		MCode.Format("S - ");

	switch (McodeActions[i].Action)
	{
	case M_Action_None:
		break;

	case M_Action_Setbit:
		if (VerifyIntegerRange(McodeActions[i].dParams[0],0,63,"Setbit Number",MCode)) return 1;
		if (VerifyIntegerRange(McodeActions[i].dParams[1],0, 1,"Setbit Value",MCode)) return 1;
		break;

	case M_Action_SetTwoBits:
		if (VerifyIntegerRange(McodeActions[i].dParams[0],0,63,"Setbit Number #1",MCode)) return 1;
		if (VerifyIntegerRange(McodeActions[i].dParams[1],0, 1,"Setbit Value #1",MCode)) return 1;
		if (VerifyIntegerRange(McodeActions[i].dParams[0],0,63,"Setbit Number #2",MCode)) return 1;
		if (VerifyIntegerRange(McodeActions[i].dParams[1],0, 1,"Setbit Value #2",MCode)) return 1;
		break;

	case M_Action_DAC:
		if (VerifyIntegerRange(McodeActions[i].dParams[0],0,7,"DAC Channel",MCode)) return 1;
		if (VerifyIntegerRange(McodeActions[i].dParams[3],-2048,2047,"DAC Min",MCode)) return 1;
		if (VerifyIntegerRange(McodeActions[i].dParams[4],-2048,2047,"DAC Max",MCode)) return 1;
		if (McodeActions[i].dParams[4] < McodeActions[i].dParams[3])
		{
			AfxMessageBox(MCode + " DAC Max less than Min");
			return 1;
		}
		break;

	case M_Action_Program:
		if (VerifyIntegerRange(McodeActions[i].dParams[0],1,7,"Thread",MCode)) return 1;
		if (VerifyIntegerRange(McodeActions[i].dParams[1],-1,99,"Persist Variable",MCode)) return 1;
		break;
	}
	return 0;
}

// verify a parameter is an integer and within a secified range

int COptionsDlg::VerifyIntegerRange(double value, int min, int max, CString s, CString MCode)
{
	CString err;

	if (value != (int)value)
	{
		AfxMessageBox(MCode + s + " - not an integer");
		return 1;
	}

	if (value < min)
	{
		CString w;
		w.Format(" too small - min allowed value = %d",min);
		AfxMessageBox(MCode + s + w);
		return 1;
	}

	if (value > max)
	{
		CString w;
		w.Format(" too large - max allowed value = %d",max);
		AfxMessageBox(MCode + s + w);
		return 1;
	}

	return 0;
}
